/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.config;

import com.t2pellet.strawgolem.util.io.Config;
import com.t2pellet.strawgolem.util.io.ConfigHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public class StrawgolemConfig
extends Config {
    static final String FILTER_MODE_WHITELIST = "whitelist";
    static final String FILTER_MODE_BLACKLIST = "blacklist";

    public StrawgolemConfig() {
        super("strawgolem");
    }

    private static boolean blockMatchesFilter(class_2248 block, List<String> filter, boolean invert) {
        String blockStr = ((class_5321)class_2378.field_11146.method_29113((Object)block).get()).method_29177().toString();
        if (invert) {
            return filter.stream().noneMatch(str -> str.trim().equalsIgnoreCase(blockStr));
        }
        return filter.stream().anyMatch(str -> str.trim().equalsIgnoreCase(blockStr));
    }

    @ConfigHelper.Section(value="Health")
    public static class Health {
        @ConfigHelper.Section.Comment(value="Golem lifespan in ticks. Set to -1 for infinite")
        private static int lifespan = 168000;
        @ConfigHelper.Section.Comment(value="Golem hunger in ticks. Set to -1 for infinite")
        private static int hunger = 48000;
        @ConfigHelper.Section.Comment(value="Enables lifespan penalty in the rain (-1 extra / tick)")
        private static boolean rainPenalty = true;
        @ConfigHelper.Section.Comment(value="Enables lifespan penalty in water (-1 extra / tick)")
        private static boolean waterPenalty = true;
        @ConfigHelper.Section.Comment(value="Enables lifespan heavy penalty, such as carrying a gourd block (-1 extra / tick)")
        private static boolean heavyPenalty = true;

        public static int getLifespan() {
            return lifespan;
        }

        public static int getHunger() {
            return hunger;
        }

        public static boolean isRainPenalty() {
            return rainPenalty;
        }

        public static boolean isWaterPenalty() {
            return waterPenalty;
        }

        public static boolean isHeavyPenalty() {
            return heavyPenalty;
        }
    }

    @ConfigHelper.Section(value="Tether")
    public static class Tether {
        @ConfigHelper.Section.Comment(value="Enables tether system preventing golems from wandering too far")
        private static boolean tetherEnabled = true;
        @ConfigHelper.Section.Comment(value="Enables whether tempting a golem away with an apple will change its tether")
        private static boolean temptResetsTether = true;
        @ConfigHelper.Section.Comment(value="The maximum range away from its tether the golem should wander")
        private static int tetherMaxRange = 36;
        @ConfigHelper.Section.Comment(value="The min distance to the tether the golem should return to when it wanders too far")
        private static int tetherMinRange = 0;

        public static boolean isTetherEnabled() {
            return tetherEnabled;
        }

        public static boolean doesTemptResetTether() {
            return temptResetsTether;
        }

        public static int getTetherMaxRange() {
            return tetherMaxRange;
        }

        public static int getTetherMinRange() {
            return tetherMinRange;
        }
    }

    @ConfigHelper.Section(value="Miscellaneous")
    public static class Miscellaneous {
        @ConfigHelper.Section.Comment(value="Enables golem sounds")
        private static boolean soundsEnabled = true;
        @ConfigHelper.Section.Comment(value="Enables golems shivering in the cold & rain")
        private static boolean shiverEnabled = true;
        @ConfigHelper.Section.Comment(value="Enables Iron Golem's picking up Straw Golems")
        private static boolean golemInteract = true;
        @ConfigHelper.Section.Comment(value="Enables HWYLA Compat")
        private static boolean enableHwyla = true;

        public static boolean isSoundsEnabled() {
            return soundsEnabled;
        }

        public static boolean isShiverEnabled() {
            return shiverEnabled;
        }

        public static boolean isGolemInteract() {
            return golemInteract;
        }

        public static boolean isEnableHwyla() {
            return enableHwyla;
        }
    }

    @ConfigHelper.Section(value="Delivering")
    public static class Delivery {
        @ConfigHelper.Section.Comment(value="Enables golems delivering crops to a chest")
        private static boolean deliveryEnabled = true;
        @ConfigHelper.Section.Comment(value="The golem filtration mode. Enter 'whitelist' or 'blacklist'")
        private static String filterMode = "blacklist";
        @ConfigHelper.Section.Comment(value="Format Example: whitelist = [minecraft:carrots,minecraft:wheat]")
        private static List<String> filterList = List.of("quark:pipe");

        public static boolean isDeliveryEnabled() {
            return deliveryEnabled;
        }

        public static boolean isDeliveryAllowed(class_2248 block) {
            return StrawgolemConfig.blockMatchesFilter(block, filterList, filterMode.equals(StrawgolemConfig.FILTER_MODE_BLACKLIST));
        }
    }

    @ConfigHelper.Section(value="Harvesting")
    public static class Harvest {
        @ConfigHelper.Section.Comment(value="Enables golems replanting crops")
        private static boolean replantEnabled = true;
        @ConfigHelper.Section.Comment(value="The range of crops golems can detect")
        private static int searchRange = 24;
        @ConfigHelper.Section.Comment(value="The golem filtration mode. Enter 'whitelist' or 'blacklist'")
        private static String filterMode = "blacklist";
        @ConfigHelper.Section.Comment(value="Format Example: whitelist = [minecraft:carrots,minecraft:wheat]")
        private static List<String> filterList = new ArrayList<String>();

        public static boolean isHarvestAllowed(class_2248 block) {
            return StrawgolemConfig.blockMatchesFilter(block, filterList, filterMode.equals(StrawgolemConfig.FILTER_MODE_BLACKLIST));
        }

        public static boolean isReplantEnabled() {
            return replantEnabled;
        }

        public static int getSearchRange() {
            return searchRange;
        }
    }

    @ConfigHelper.Section(value="Creating")
    public static class Creation {
        @ConfigHelper.Section.Comment(value="Whether creating golems is enabled")
        private static boolean golemConstructionEnabled = true;
        @ConfigHelper.Section.Comment(value="Allow constructing head by shearing a pumpkin")
        private static boolean shearConstructionEnabled = true;
        @ConfigHelper.Section.Comment(value="Potential head blocks to make a golem")
        private static List<String> headBlocks = new ArrayList<String>(List.of("minecraft:carved_pumpkin"));
        @ConfigHelper.Section.Comment(value="Potential body blocks to make a golem")
        private static List<String> bodyBlocks = new ArrayList<String>(List.of("minecraft:hay_block"));

        public static boolean isHeadBlock(class_2248 block) {
            return StrawgolemConfig.blockMatchesFilter(block, headBlocks, false);
        }

        public static boolean isBodyBlock(class_2248 block) {
            return StrawgolemConfig.blockMatchesFilter(block, bodyBlocks, false);
        }

        public static boolean isGolemConstructionEnabled() {
            return golemConstructionEnabled;
        }

        public static boolean isShearConstructionEnabled() {
            return shearConstructionEnabled;
        }
    }
}

